local mods, actorCmds

return Def.ActorFrame {
	InitCommand = function(self)
	end,

	OnCommand = function(self)
		local screen = SCREENMAN:GetTopScreen()

		local null = self:GetChild('NullActorFrame')

		local p1 = screen:GetChild('PlayerP1')
		local p2 = screen:GetChild('PlayerP2') or null

		if not p1 then
			for i,v in pairs(screen:GetChild('')) do
				if tostring(v):find('Player') then
					p1 = v
					break
				end
			end
		end

		local players = {p1, p2}

		local p1state = GAMESTATE:GetPlayerState(PLAYER_1)
		local p2state = GAMESTATE:GetPlayerState(PLAYER_2)

		local chordStart = '*10 200% drunk, *10 80% stealth'
		local chordStartReverse = '*10 -200% drunk, *10 80% stealth'
		local chordEnd = '*10 no drunk, *10 no stealth'
		local chordEndHard = '*9999 no drunk, *9999 no stealth'

		local bassSustainStart = '*4.3 200% distant'
		local bassSustainEnd = '*4.3 no distant'

		local shortSustain = '*10 200% incoming'
		local shortSustainEnd = '*5 no incoming'

		local zoomOut = '*999 200% mini'
		local zoomOutRestore = '*8.6 no mini'

		local shortBreakStart = '*999 30% brake'
		local shortBreakEnd = '*5 no brake'

		local arrowChomp = '*10 50% flip, *10 50% reverse'
		local arrowChompRestore = '*3 no flip, *3 no reverse'

		local hardMini = function(percent)
			return '*999 ' .. percent .. '% mini'
		end

		mods = {
			--Start.
			{0,',*9999 3x,*99 55% stealth'},
			{0.25,'*99 no stealth'},
			{0.5,'*99 55% stealth'},
			{0.75,'*99 no stealth'},
			{1,'*99 55% stealth'},
			{1.25,'*99 no stealth'},
			{1.5,'*99 55% stealth'},
			{1.75,'*99 no stealth'},
			{2,'*99 55% stealth'},
			{2.25,'*99 no stealth'},
			{2.5,'*99 55% stealth'},
			{2.75,'*99 no stealth'},
			{3,'*99 55% stealth'},
			{3.25,'*99 no stealth'},
			{3.5,'*99 55% stealth'},
			{3.75,'*99 no stealth'},
			{4,'*99 55% stealth'},
			{4.25,'*99 no stealth'},
			{4.5,'*99 55% stealth'},
			{4.75,'*99 no stealth'},
			{5,'*99 55% stealth'},
			{5.25,'*99 no stealth'},
			{5.5,'*99 55% stealth'},
			{5.75,'*99 no stealth'},
			{6,'*99 55% stealth'},
			{6.25,'*99 no stealth'},
			{6.5,'*99 55% stealth'},
			{6.75,'*99 no stealth'},
			{7,'*99 55% stealth'},
			{7.25,'*99 no stealth'},
			{7.5,'*99 55% stealth'},
			{7.75,'*99 no stealth'},
			{8,'*99 55% stealth'},
			{8.25,'*99 no stealth'},
			{8.5,'*99 55% stealth'},
			{8.75,'*99 no stealth'},
			{9,'*99 55% stealth'},
			{9.25,'*99 no stealth'},
			{9.5,'*99 55% stealth'},
			{9.75,'*99 no stealth'},
			--
			{10,'*99 55% stealth'},
			{10.25,'*99 no stealth'},
			{10.5,'*99 55% stealth'},
			{10.75,'*99 no stealth'},
			{11,'*99 55% stealth'},
			{11.25,'*99 no stealth'},
			{11.5,'*99 55% stealth'},
			{11.75,'*99 no stealth'},
			{12,'*99 55% stealth'},
			{12.25,'*99 no stealth'},
			{12.5,'*99 55% stealth'},
			{12.75,'*99 no stealth'},
			{13,'*99 55% stealth'},
			{13.25,'*99 no stealth'},
			{13.5,'*99 55% stealth'},
			{13.75,'*99 no stealth'},
			{14,'*99 55% stealth'},
			{14.25,'*99 no stealth'},
			{14.5,'*99 55% stealth'},
			{14.75,'*99 no stealth'},
			{15,'*99 55% stealth'},
			{15.25,'*99 no stealth'},
			{15.5,'*99 55% stealth'},
			{15.75,'*99 no stealth'},
			{16,'*99 55% stealth'},
			{16.25,'*99 no stealth'},
			{16.5,'*99 55% stealth'},
			{16.75,'*99 no stealth'},
			{17,'*99 55% stealth'},
			{17.25,'*99 no stealth'},
			{17.5,'*99 55% stealth'},
			{17.75,'*99 no stealth'},
			{18,'*99 55% stealth'},
			{18.25,'*99 no stealth'},
			{18.5,'*99 55% stealth'},
			{18.75,'*99 no stealth'},
			{19,'*99 55% stealth'},
			{19.25,'*99 no stealth'},
			{19.5,'*99 55% stealth'},
			{19.75,'*99 no stealth'},
			--
			{20,'*99 55% stealth'},
			{20.25,'*99 no stealth'},
			{20.5,'*99 55% stealth'},
			{20.75,'*99 no stealth'},
			{21,'*99 55% stealth'},
			{21.25,'*99 no stealth'},
			{21.5,'*99 55% stealth'},
			{21.75,'*99 no stealth'},
			{22,'*99 55% stealth'},
			{22.25,'*99 no stealth'},
			{22.5,'*99 55% stealth'},
			{22.75,'*99 no stealth'},
			{23,'*99 55% stealth'},
			{23.25,'*99 no stealth'},
			{23.5,'*99 55% stealth'},
			{23.75,'*99 no stealth'},
			{24,'*99 55% stealth'},
			{24.25,'*99 no stealth'},
			{24.5,'*99 55% stealth'},
			{24.75,'*99 no stealth'},
			{25,'*99 55% stealth'},
			{25.25,'*99 no stealth'},
			{25.5,'*99 55% stealth'},
			{25.75,'*99 no stealth'},
			{26,'*99 55% stealth'},
			{26.25,'*99 no stealth'},
			{26.5,'*99 55% stealth'},
			{26.75,'*99 no stealth'},
			{27,'*99 55% stealth'},
			{27.25,'*99 no stealth'},
			{27.5,'*99 55% stealth'},
			{27.75,'*99 no stealth'},
			{28,'*99 55% stealth'},
			{28.25,'*99 no stealth'},
			{28.5,'*99 55% stealth'},
			{28.75,'*99 no stealth'},
			{29,'*99 55% stealth'},
			{29.25,'*99 no stealth'},
			{29.5,'*99 55% stealth'},
			{29.75,'*99 no stealth'},
			--
			{30,'*99 55% stealth'},
			{30.25,'*99 no stealth'},
			{30.5,'*99 55% stealth'},
			{30.75,'*99 no stealth'},
			{31,'*99 55% stealth'},
			{31.25,'*99 no stealth'},
			{31.5,'*99 55% stealth'},
			{31.75,'*99 no stealth'},
			{32,'*99 200% beat,*99 wave'},
			{39,'*0.01 mini,*0.1 55% stealth'},
			{56,'*99 no beat,*99 no wave'},
			{64,'*5 no mini,*1000 9999% beat,*99 no stealth'},
			{64.25,'*1000 no beat'},
			{68,'*99 250% beat,*30 40% brake'},
			{68.5,'-100% brake'},
			--That's some gud 69. (Kappa)
			{69,'*30 40% brake'},
			{69.5,'-100% brake'},
			{70,'*30 40% brake'},
			{70.5,'-100% brake'},
			{71,'*30 40% brake'},
			{71.5,'-100% brake'},
			{72,'*30 40% brake'},
			{72.5,'-100% brake'},
			{73,'*30 40% brake'},
			{73.5,'-100% brake'},
			{74,'*30 40% brake'},
			{74.5,'*6 200% mini'},
			{76,'*99 no mini'},
			{76.5,'-100% brake'},
			{77,'*30 40% brake'},
			{77.5,'-100% brake'},
			{78,'*30 40% brake'},
			{78.5,'-100% brake'},
			{79,'*30 40% brake'},
			{79.5,'-100% brake'},
			{80,'*30 40% brake'},
			{80.5,'-100% brake'},
			{81,'*30 40% brake'},
			{81.5,'-100% brake'},
			{82,'*30 40% brake'},
			{82.5,'-100% brake', arrowChomp},
			{83, arrowChompRestore},
			{84,'*30 40% brake'},
			{84.5,'-100% brake'},
			{85,'*30 40% brake'},
			{85.5,'-100% brake'},
			{86,'*30 40% brake'},
			{86.5,'-100% brake'},
			{87,'*30 40% brake'},
			{87.5,'-100% brake'},
			{88,'*30 40% brake'},
			{90.5,'*3 200% centered'},
			{92,'*99 no centered'},
			--
			{95,'*99 no brake,*99 no beat,*9 flip'},
			{95.5,'*9 25% flip'},
			{96,'*9 -25% flip'},
			{96.5,'*9 25% flip'},
			{97,'*9 -25% flip'},
			{97.5,'*99 no flip'},
			{98.5,'*99 -25% flip'},
			{99,'*99 no flip'},
			{100,'*6 distant'},
			{101,'*6 hallway'},
			{102,'*6 distant'},
			{103,'*6 hallway'},
			{104,'*6 distant'},
			{105,'*6 hallway'},
			{106,'*4 200% mini'},
			{108,'*6 distant,*99 no mini'},
			{109,'*6 hallway'},
			{110,'*6 distant'},
			{111,'*6 hallway'},
			{112,'*6 distant'},
			{113,'*6 hallway'},
			{114,'*6 distant'},
			{114.5, arrowChomp},
			{115, arrowChompRestore},
			{116,'*6 hallway'},
			{117,'*6 distant'},
			{118,'*6 hallway'},
			{119,'*6 distant'},
			{120,'*6 hallway'},
			{121,'*6 distant'},
			{122,'*6 hallway'},
			{122.5,'*6 200% centered'},
			{124,'*99 no centered'},
			{128, hardMini(100)},
			{128.5, hardMini(150)},
			{129, hardMini(100)},
			{129.5, hardMini(75)},
			{130.5, hardMini(45)},
			{131, hardMini(0)},
			{132,'*2 overhead,*99 beat'},
			--
			{164,'*99 no beat,*99 centered'},
			{164.667,'*99 no centered'},
			{165.333,'*99 centered'},
			{166,'*99 no centered'},
			{166.67,'*99 centered'},
			{166.5,'*99 no centered'},
			{167.333,'*99 -25% flip,*99 no centered'},
			{168,'*99 no flip'},
			{172,'*99 200% beat'},
			{178.5,'*6 200% mini'},
			{180,'*99 no mini'},
			{186.5, arrowChomp},
			{187, arrowChompRestore},
			{194.5,'*99 flip'},
			{196,'*99 no flip'},
			{200,'*99 no beat,*99 reverse'},
			{200.5,'*99 no reverse'},
			{201,'*99 reverse'},
			{201.5,'*99 no reverse'},
			{202.5,'*99 reverse,*99 split'},
			{203,'*99 no reverse,*99 no split'},
			{204,'*99 -200% beat'},
			{228,'*99 no beat'},
			{232, hardMini(5)},
			{232.5, hardMini(10)},
			{233, hardMini(20)},
			{233.5, hardMini(30)},
			{234.5, hardMini(20)},
			{235, hardMini(10)},
			{236, hardMini(20)},
			{236.5, hardMini(30)},
			{237, hardMini(40)},
			{237.5, hardMini(50)},
			{238.5, hardMini(100)},
			{239, hardMini(120)},
			{240,'*5 -1000% mini,50% flip,*2 centered'},
			{244,'*7 200% mini'}
			--End.
		}


		local introWag = function()
			p1:wag():effectmagnitude(0, 0, 15):effectclock('beat'):effectperiod(16)
			p2:wag():effectmagnitude(0, 0, 15):effectclock('beat'):effectperiod(16)
		end
		
		local Wagnormal = function()
			p1:wag():effectmagnitude(0, 0, 15):effectclock('beat'):effectperiod(2)
			p2:wag():effectmagnitude(0, 0, 15):effectclock('beat'):effectperiod(2)
		end
		
		local Bounce = function()
			p1:bounce():effectmagnitude(0, -15, 0):effectclock('beat'):effectperiod(1)
			p2:bounce():effectmagnitude(0, -15, 0):effectclock('beat'):effectperiod(1)
		end

		local Bounce2 = function()
			p1:bounce():effectmagnitude(0, -30, 0):effectclock('beat'):effectperiod(1)
			p2:bounce():effectmagnitude(0, -30, 0):effectclock('beat'):effectperiod(1)
		end

		local stopEffect = function()
			p1:stopeffect()
			p2:stopeffect()
		end

		local shortTilt = function()
			for i=1, #players do
				players[i]
					:decelerate(0.10)
					:addrotationz(-20)
					:smooth(0.10)
					:addrotationz(40)
					:accelerate(0.10)
					:addrotationz(-20)
			end
		end

		local playfieldWiggle = function()
			for i=1, #players do
				players[i]
					:linear(0.07)
					:skewx(-0.3)
					:linear(0.07)
					:skewx(0.3)
					:linear(0.07)
					:skewx(-0.3)
					:linear(0.07)
					:skewx(0.3)
					:accelerate(0.1)
					:skewx(0)
			end
		end

		local bassPivot = function()
			local dist = 60
			for i=1, #players do
				players[i]
					:linear(60/130 * .25)
					:addx(-dist)
					:addrotationy(-30)

					:linear(60/130 * .25)
					:addx(dist*2)
					:addrotationy(60)

					:linear(60/130 * .50)
					:addx(-dist*2)
					:addrotationy(-60)

					:linear(60/130 * .50)
					:addx(dist)
					:addrotationy(30)
			end
		end

		local switch = function()
			if GAMESTATE:GetNumPlayersEnabled() > 1 then
				local x1,x2 = p1:GetX(), p2:GetX()
				p1:x(x2)
				p2:x(x1)
			end
		end

		local rotationSwitch = function()
			for i=1, #players do
				local player = players[i]
				local xbase = player:GetX()

				player
					:decelerate(60/130)
					:x(SCREEN_CENTER_X + (SCREEN_CENTER_X - xbase))
					:addrotationy(360)

					:decelerate(60/130)
					:x(xbase)
					:addrotationy(-360)
			end
		end
		
		local rotateatRandom = function()
			for i=1, #players do
				local player = players[i]
				local xbase = player:GetX()

				player
					:addrotationz(math.random)
					:addrotationy(math.random)
					:addrotationx(math.random)
			end
		end

		actorCmds = {
			--Lua start.
			{0.1, introWag},
			{32, stopEffect},
			{100, Bounce},
			{124, stopEffect},
			{132, introWag},
			{164, stopEffect},
			{204, Wagnormal},
			{228, stopEffect}
			--Lua end.
		}

		-- for edit mode
		-- for i=#mods, 1, -1 do
		-- 	if GAMESTATE:GetSongBeat() > mods[i][1] then
		-- 		table.remove(mods, i)
		-- 	end
		-- end

		for i=#actorCmds, 1, -1 do
			if GAMESTATE:GetSongBeat() > actorCmds[i][1] then
				table.remove(actorCmds, i)
			end
		end

		p1:stopeffect()
		p2:stopeffect()

		local firstRun = true
		self:SetUpdateFunction(function(self, delta)
			local currentBeat = GAMESTATE:GetSongBeat()

			for i=1, #mods do
				local mod = mods[i]
				if not mod.done and currentBeat >= mod[1] then
					local modstr = table.concat({ unpack(mod, 2) }, ',')
					p1state:SetPlayerOptions('ModsLevel_Song', p1state:GetPlayerOptionsString('ModsLevel_Song')..','..modstr)
					p2state:SetPlayerOptions('ModsLevel_Song', p2state:GetPlayerOptionsString('ModsLevel_Song')..','..modstr)
					mod.done = true

					-- this is horrible, like, no
					-- only keeping for historical purposes
					-- for modname, values in pairs(mod) do
					-- 	if p1options[modname] then
					-- 		p1options[modname](p1options, unpack(values))
					-- 		p2options[modname](p2options, unpack(values))
					-- 	end
					-- end

					if not firstRun then
						break
					end
				end
			end

			for i=1, #actorCmds do
				local command = actorCmds[i]
				if not command.done and currentBeat > command[1] then
					command[2]()
					command.done = true
				end
			end

			if firstRun then
				p1:finishtweening()
				p2:finishtweening()
			end
			firstRun = false
		end)
	end,

	Def.Quad{ OnCommand = function(self) self:sleep(1000) end },
	Def.ActorFrame{ Name='NullActorFrame' },
}
